﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB
{
    public partial class _Default : BasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            //adding line of commented text for RTC Task 350744
            UserSession.Refresh();

            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);
                //BuildMenu();

                if (!Page.IsPostBack)
                {
                    //Synchronize all settings from the database
                    SyncAppSettings();

                    USERS user = ServiceInterfaceManager.USERS_GET_BY_NAME(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, HttpContext.Current.User.Identity.Name);
                    if (user != null)
                    {
                        UserSession.DefautRegistryId = user.DEFAULT_REGISTRY_ID;
                    }
                    if (UserSession.DefautRegistryId > 0)
                    {
                        // UserSession.DefautRegistryId = user.DEFAULT_REGISTRY_ID;
                        Response.Redirect("~/Common/Default.aspx?id=" + UserSession.DefautRegistryId, false);
                    }
                    else
                    {
                        SETTINGS setting = ServiceInterfaceManager.GET_HOME_PAGE_SETTING();
                        if (setting != null && !string.IsNullOrEmpty(setting.VALUE))
                        {
                            lblDescription.Text = AntiXssEnc.Encoder.HtmlEncode(setting.VALUE);
                        }
                        else
                        {
                            lblDescription.Text = "Welcome to the Converged Registries Solution home page.";
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SyncAppSettings()
        {
            List<SETTINGS> settings = null;
            settings = ServiceInterfaceManager.SETTINGS_GET();
            AppSettings appSettings = new AppSettings();

            appSettings.SqlCommandTimeout = GetSettingValueInt(settings, "SqlCommandTimeout");
            appSettings.LogFileSize = GetSettingValueInt(settings, "LogFileSize");
            appSettings.LogFileArchive = GetSettingValueInt(settings, "LogFileArchive");
            appSettings.LogErrors = GetSettingValueBool(settings, "LogErrors");
            appSettings.LogInformation = GetSettingValueBool(settings, "LogInformation");
            appSettings.LogTiming = GetSettingValueBool(settings, "LogTiming");
            appSettings.DatabaseLogEnabled = GetSettingValueBool(settings, "DatabaseLogEnabled");
            appSettings.EventLogEnabled = GetSettingValueBool(settings, "EventLogEnabled");
            appSettings.FileLogEnabled = GetSettingValueBool(settings, "FileLogEnabled");
            appSettings.FileLogPath = GetSettingValueString(settings, "FileLogPath");
            appSettings.MviEnabled = GetSettingValueBool(settings, "MviEnabled");
            appSettings.MviProcessingCode = GetSettingValueString(settings, "MviProcessingCode");
            appSettings.MviCertName = GetSettingValueString(settings, "MviCertName");
            appSettings.MviServiceUrl = GetSettingValueString(settings, "MviServiceUrl");
            appSettings.ReportBuilderPath = GetSettingValueString(settings, "ReportBuilderPath");
            appSettings.ReportServerUrl = GetSettingValueString(settings, "ReportServerUrl");
            appSettings.ReportServicePath = GetSettingValueString(settings, "ReportServicePath");
            appSettings.SSOiLogoutUrl = GetSettingValueString(settings, "SSOiLogoutUrl");
            appSettings.EtlSchedule = GetSettingValueString(settings, "EtlSchedule");
            appSettings.EtlRetryAttempts = GetSettingValueInt(settings, "EtlRetryAttempts");
            appSettings.EtlTimeBetweenAttempts = GetSettingValueInt(settings, "EtlTimeBetweenAttempts");
            appSettings.HomePageText = GetSettingValueString(settings, "HomePageText");
            appSettings.ViaRequestingApp = GetSettingValueString(settings, "ViaRequestingApp");
            appSettings.ViaServiceUrl = GetSettingValueString(settings, "ViaServiceUrl");
            appSettings.ViaAppToken = GetSettingValueString(settings, "ViaAppToken");
            appSettings.ViaAppKey = GetSettingValueString(settings, "ViaAppKey");

            ServiceInterfaceManager.APPSETTINGS_SAVE_TO_CONFIG(appSettings);
        }

        private int GetSettingValueInt(List<SETTINGS> settings, string settingName)
        {
            int value = 0;
            var setting = settings.Where(x => x.NAME == settingName).SingleOrDefault();
            if (setting != null)
            {
                int.TryParse(setting.VALUE, out value);
            }

            return value;
        }

        private bool GetSettingValueBool(List<SETTINGS> settings, string settingName)
        {
            bool value = false;
            var setting = settings.Where(x => x.NAME == settingName).SingleOrDefault();
            if (setting != null)
            {
                bool.TryParse(setting.VALUE, out value);
            }

            return value;
        }

        private string GetSettingValueString(List<SETTINGS> settings, string settingName)
        {
            string value = "";
            var setting = settings.Where(x => x.NAME == settingName).SingleOrDefault();
            if (setting != null)
            {
                value = setting.VALUE;
            }

            return value;
        }
    }
}